<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'guid', 'role', 'status');
    protected $visible = array('name', 'email', 'password', 'guid', 'role', 'status');

    public function orders()
    {
        return $this->hasMany('App\Models\Order', 'id_user');
    }

    public function customer_meta()
    {
        return $this->hasOne('App\Models\Customer_meta', 'id_user');
    }

}